/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.frame;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.TreeMap;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.Keyframes;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.IKeyframe;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.IKeyframeTypeSerializer;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.api.lifecycle.Registries;
import lib.toma.animations.engine.frame.FrameProviderType;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class TargetAndBackFrameProvider
implements IKeyframeProvider {
    private final AnimationStage targetStage;
    private final FramePair frames;

    public TargetAndBackFrameProvider(AnimationStage stage, IKeyframe mov, IKeyframe ret) {
        this.targetStage = stage;
        this.frames = new FramePair(mov, ret);
    }

    @Override
    public boolean shouldAdvance(AnimationStage stage, float progress, int frameIndex) {
        return frameIndex == 0 && progress >= 0.5f;
    }

    @Override
    public IKeyframe getCurrentFrame(AnimationStage stage, float progress, int frameIndex) {
        return frameIndex != 0 ? this.frames.returning() : this.frames.toTarget();
    }

    @Override
    public IKeyframe getOldFrame(AnimationStage stage, int frameIndex) {
        return frameIndex != 0 ? this.frames.toTarget() : Keyframes.none();
    }

    @Override
    public IAnimationEvent[] getEvents() {
        return IAnimationEvent.NO_EVENTS;
    }

    @Override
    public FrameProviderType<?> getType() {
        return FrameProviderType.TARGET_AND_BACK;
    }

    @Override
    public Map<AnimationStage, IKeyframe[]> getFrameMap() {
        TreeMap<AnimationStage, IKeyframe[]> map = AnimationUtils.createSortedMap();
        IKeyframe[] array = new IKeyframe[]{this.frames.toTarget(), this.frames.returning()};
        map.put(this.targetStage, array);
        return map;
    }

    @Override
    public void initCache(Map<AnimationStage, Integer> cache) {
        cache.put(this.targetStage, 0);
    }

    public static final class Serializer
    implements IKeyframeTypeSerializer<TargetAndBackFrameProvider> {
        @Override
        public void serialize(JsonObject data, TargetAndBackFrameProvider provider, JsonSerializationContext context) {
            FramePair pair = provider.frames;
            data.addProperty("target", provider.targetStage.toString());
            data.add("mov", context.serialize((Object)pair.toTarget(), IKeyframe.class));
            data.add("ret", context.serialize((Object)pair.returning(), IKeyframe.class));
        }

        @Override
        public TargetAndBackFrameProvider deserialize(JsonObject source, JsonDeserializationContext context, IAnimationEvent[] events) throws JsonParseException {
            String stageKey = JSONUtils.func_151200_h((JsonObject)source, (String)"target");
            AnimationStage stage = Registries.ANIMATION_STAGES.getElement(new ResourceLocation(stageKey));
            if (stage == null) {
                throw new JsonSyntaxException("Unknown animation stage: " + stageKey);
            }
            IKeyframe mov = (IKeyframe)context.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)source, (String)"mov"), IKeyframe.class);
            IKeyframe ret = (IKeyframe)context.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)source, (String)"ret"), IKeyframe.class);
            return new TargetAndBackFrameProvider(stage, mov, ret);
        }
    }

    private static class FramePair {
        private final IKeyframe mov;
        private final IKeyframe ret;

        FramePair(IKeyframe mov, IKeyframe ret) {
            this.mov = mov;
            this.ret = ret;
            ret.baseOn(mov);
        }

        public IKeyframe toTarget() {
            return this.mov;
        }

        public IKeyframe returning() {
            return this.ret;
        }
    }
}

